% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-list.r
\name{gen.list.expr}
\alias{gen.list.expr}
\alias{gen.vector.expr}
\alias{gen.named.list.expr}
\alias{gen.named.vector.expr}
\title{Generate List and Vector Expressions with List Comprehension}
\usage{
gen.list.expr(.expr, ...)

gen.vector.expr(.expr, ...)

gen.named.list.expr(.str, .expr, ...)

gen.named.vector.expr(.str, .expr, ...)
}
\arguments{
\item{.expr}{A base expression which is partially evaluated for all combinations of variables. 
It may still contain free variables.}

\item{...}{Arbitrary many variable ranges and conditions.}

\item{.str}{A character pattern, containing expressions to be evaluated in \{\}-brackets.}
}
\value{
Returns an expression containing a list or a vector which might be evaluated later.
The argument \code{.expr} is partially evaluated, where all free variables are substituted for which a range is given.
The other variables remain untouched.
}
\description{
Functions to transform a base expression containing free variables into a list or a vector of expressions,
based on variable ranges and additional conditions.
}
\details{
See \code{\link{gen.list}} for more details on the \code{.expr} and \code{...} parameters.

See \code{\link{gen.named.list}} for more details on the \code{.str} parameter.

For variables with underscores additionally the evaluation of indices in \code{()}-brackets is supported.
For example, an expression \code{x_(i+1)} is evaluated as \code{x_3} for \code{i = 2}.
}
\examples{
# An expression which is partially evaluated
gen.list.expr(a_i + 2 * i, i = 1:4)

# Generate an expression with placeholders a_i,
# generate data for a_1, ..., a_4 and finally evaluate it
expr <- gen.vector.expr(a_i + a_(j+1), i = 1:3, j = 1:3, i != j)
data <- gen.data.frame(c(a_1 = a_1, ..., a_4 = a_4), a_ = 1:2)
eval(expr, data)

}
\seealso{
\code{\link{gen.list}} to generate lists,
  \code{\link{gen.named.list}} to generate named lists,  
  and \link{listcompr} for an overview of all list comprehension functions.
}
