% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal.R
\name{marginal}
\alias{marginal}
\title{Marginal (SQ/CP) approach}
\usage{
marginal(y, x, adjustment = NULL, pop_struct = NULL)
}
\arguments{
\item{y}{matrix of traits (n observations by k traits)}

\item{x}{matrix of SNPs (n observations by m SNPs)}

\item{adjustment}{matrix of covariates to adjust traits}

\item{pop_struct}{matrix of PCs that captures population structure}
}
\value{
A data frame of p-values where the columns are the cross products/squared residuals
and the rows are SNPs.
}
\description{
The \code{marginal} function performs a trait-by-trait univariate test for latent interactions
using the squared residuals and cross products.
}
\examples{
# set seed
set.seed(123)

# Generate SNPs and traits
X <- matrix(rbinom(10*2, size = 2, prob = 0.25), ncol = 2)
Y <- matrix(rnorm(10*4), ncol = 4)

out <- marginal(Y, X)

}
\seealso{
\code{\link{marginal_plink}}
}
