% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.literanger}
\alias{merge.literanger}
\title{Merge two random forests}
\usage{
\method{merge}{literanger}(x, y, save_memory = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{x}{A trained random forest \code{literanger} object.}

\item{y}{A trained random forest \code{literanger} object.}

\item{save_memory}{Ignored, only used in training (perhaps future use).}

\item{verbose}{Print additional debug output from merging procedure.}

\item{...}{Ignored.}
}
\value{
Object of class \code{literanger} with a \emph{copy} of the trees from \code{x} and
\code{y} held in the \code{cpp11_ptr} item, and the following items:
\describe{
\item{\code{tree_type}}{The type of tree in the forest, either 'classification'
or 'regression'.}
\item{\code{n_tree}}{The sum of the number of trees in \code{x} and \code{y}.}
\item{\code{training}}{An empty list; as the result is due to merging, not
training.}
\item{\code{predictors}}{A list with the names of the predictors, the names of
the unordered predictors, and the levels of any factors.}
\item{\code{response}}{The levels and type indicator (e.g. logical, factor, etc)
of the response.}
\item{\code{oob_error}}{NULL, as there is no consensus on how to merge OOB
estimates}
\item{\code{cpp11_ptr}}{An external pointer to the \emph{merged} forest. DO NOT
MODIFY.}
}
}
\description{
Copy the trees from two forests to construct a new random forest object.
}
\details{
This is a naive implementation of a random-forest merge procedure. The trees
from each forest are copied and then used to construct a new random forest
object.

Classification and regression forests cannot be mixed together. The response
type and levels (if a factor) must match.

The predictor names, type, and levels (if a factor) must match, although they
can be provided in a different order.

There is no requirement that the forests were trained on the same data; just
the same data types.

Internally, literanger will 'map' any differences in the order of the
predictors (or its internal representation of response values) between \code{x}
and \code{y} so that the result has the same ordering as \code{x}.

The out-of-bag error is discarded, along with the training information, as
the result is a \emph{merged} forest (not a \emph{trained} one). It is up to you,
the user, to keep track of the training parameters of \code{x} and \code{y} if they are
still of use to you.
}
\examples{
## Train two classification forests
train_idx <- sample(nrow(iris), 2/3 * nrow(iris))
iris_train <- iris[train_idx, ]
iris_test <- iris[-train_idx, ]
lr_x <- train(data=iris_train, response_name="Species", n_tree=32)
lr_y <- train(data=iris_train, response_name="Species", n_tree=32)

## Merge
lr_iris <- merge(lr_x, lr_y)
pred_iris <- predict(lr_iris, newdata=iris_test)
table(iris_test$Species, pred_iris$values)

}
\author{
stephematician \href{mailto:stephematician@gmail.com}{stephematician@gmail.com}.
}
