% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_weighted_forc.R
\name{performance_weighted_forc}
\alias{performance_weighted_forc}
\title{MSE or RMSE weighted forecast}
\usage{
performance_weighted_forc(
  ...,
  eval_window,
  errors = "mse",
  return_weights = FALSE
)
}
\arguments{
\item{...}{Two or more forecasts of class Forecast.}

\item{eval_window}{Integer representing the window over which forecast
accuracy is evaluated. Forecasts are weighted based on their accuracy over
the past \code{eval_window} number of periods.}

\item{errors}{Character, either "mse", "rmse", "mae", or "mape". Selects what
forecast accuracy function is used to evaluate forecast errors.}

\item{return_weights}{Boolean, selects whether the weights used to weight
forecasts in each period are returned. If TRUE, a data frame of weights is
returned to the Global Environment.}
}
\value{
\code{\link{Forecast}} object that contains the weighted forecast.
}
\description{
\code{performance_weighted_forc} takes two or more forecasts, an evaluation window,
and an error function. For each forecast period, the error function is used
to calculate forecast accuracy over the past \code{eval_window} number of
periods. The forecast accuracy of each forecast is used to weight forecasts
based on performance. Returns a weighted forecast. Optionally returns the set
of weights used to weight forecasts in each period.
}
\details{
Forecasts are weighted in each period with the following function. The error
function used is MSE or RMSE depending on user selection. This example shows
MSE errors.
\deqn{weight = (1 / MSE(forecast)) / (1 / sum(MSE(forecasts)))}
}
\examples{
y1_forecast <- Forecast(
  origin = as.Date(c("2009-03-31", "2009-06-30", "2009-09-30", "2009-12-31",
                     "2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31", 
                     "2011-03-31", "2011-06-30")),
  future = as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                     "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                     "2012-03-31", "2012-06-30")),
  forecast = c(1.33, 1.36, 1.38, 1.68, 1.60, 1.55, 1.32, 1.22, 1.08, 0.88),
  realized = c(1.09, 1.71, 1.09, 2.46, 1.78, 1.35, 2.89, 2.11, 2.97, 0.99),
  h_ahead = 4L
)

y2_forecast <- Forecast(
  origin = as.Date(c("2009-03-31", "2009-06-30", "2009-09-30", "2009-12-31",
                     "2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31", 
                     "2011-03-31", "2011-06-30")),
  future = as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                     "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                     "2012-03-31", "2012-06-30")),
  forecast = c(0.70, 0.88, 1.03, 1.05, 1.01, 0.82, 0.95, 1.09, 1.07, 1.06),
  realized = c(1.09, 1.71, 1.09, 2.46, 1.78, 1.35, 2.89, 2.11, 2.97, 0.99),
  h_ahead = 4L
)

performance_weighted_forc(
  y1_forecast, y2_forecast,
  eval_window = 2L,
  errors = "mse",
  return_weights = FALSE
)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
