% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.mcd.R
\name{bootstrap.mcd}
\alias{bootstrap.mcd}
\title{Bootstrap procedure for Multonimal Canonical Decomposition Model}
\usage{
bootstrap.mcd(object, Bsamples = 1000)
}
\arguments{
\item{object}{An output object from mcd1 or mcd2}

\item{Bsamples}{Number of Bootstrap samples to take}
}
\value{
BBdf Bootstrap estimates of B

BVdf Bootstrap estimates of V
}
\description{
Bootstrap procedure for Multonimal Canonical Decomposition Model
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lpca[, 1:8])
X = as.matrix(dataExample_lpca[, 9:13])
# supervised
output = mcd1(X, Y, S = 2, ord.z = 2)
#' boot.output = bootstrap.mcd(output, Bsamples = 100)
plot(boot.output)
}

}
