% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lpca.R
\name{plot.lpca}
\alias{plot.lpca}
\title{Plots a Logistic PCA Model}
\usage{
\method{plot}{lpca}(
  x,
  dims = c(1, 2),
  type = "H",
  pmarkers = seq(0.1, 0.9, by = 0.1),
  ycol = "darkgreen",
  xcol = "darkblue",
  ocol = "grey",
  ...
)
}
\arguments{
\item{x}{an object of type lpca}

\item{dims}{which dimensions to visualize}

\item{type}{either H (hybrid), I (inner product/pca), or D (distance/melodic)}

\item{pmarkers}{vector or list of length R (the number of response variables) with values between 0 and 1 for markers on the response variable axes.}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from lpca
}
\description{
Plots a Logistic PCA Model
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_lpca[, 1:8])
X = as.matrix(dataExample_lpca[, 9:13])
# unsupervised
output = lpca(Y = Y, S = 2)
plot(output)
}

}
