% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processSettings.R
\name{processSettings}
\alias{processSettings}
\title{Process settings file to extract relevant information.}
\usage{
processSettings(settingsFile, settings, getFilepaths = FALSE, types = "wav")
}
\arguments{
\item{settingsFile}{Filepath to the settings file (csv).}

\item{settings}{data.frame created either by reading a settings file (csv) or
using the \code{\link{createSettings}} function. Not needed if settingsFile is specified.}

\item{getFilepaths}{Logical, indicating whether to add filepath information
using \code{\link{getFilepaths}}.}

\item{types}{Character. If getFilepaths is TRUE, which types of files to look for ('wav' or 'mp3').}
}
\value{
A list with information needed for sound localization, including
    microphone coordinates, the existing detections, channels to use
    for each recording unit, and information specifying the size and
    resolution of the grid within which to localize sound sources.
}
\description{
\code{processSettings} reads information from a settings file (csv) and
combines them into a list for subsequent localization.
}
\examples{
    #Read example data
    settings <- read.csv(system.file('extdata', 'Ex_20200617_090000_Settings.csv',
                                     package = 'locaR'), stringsAsFactors = FALSE)

    #Over-write default values for SiteWavsFolder, CoordinatesFile, and ChannelsFile
    settings$Value[settings$Setting == 'SiteWavsFolder'] <-
                   system.file('extdata', package = 'locaR')
    settings$Value[settings$Setting == 'CoordinatesFile'] <-
                   system.file('extdata', 'Vignette_Coordinates.csv', package = 'locaR')
    settings$Value[settings$Setting == 'ChannelsFile'] <-
                   system.file('extdata', 'Vignette_Channels.csv', package = 'locaR')

    #Run processSettings() function
    st <- processSettings(settings = settings, getFilepaths = FALSE)
}
