% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{message}
\alias{message}
\title{Message Log Handler}
\usage{
message(..., domain = NULL, appendLF = TRUE, .loggit = NA, echo = get_echo())
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or (for
    \code{message} only) a single condition object.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated, see also the note in \code{\link[base]{stop}}.}

\item{appendLF}{logical: should messages given as a character string
    have a newline appended?}

\item{.loggit}{Should the condition message be added to the log?
If \code{NA} the log level set by \code{set_log_level()} is used to determine if the condition should be logged.}

\item{echo}{Should the log entry (json) be echoed to \code{stdout} as well?}
}
\value{
Invisible \code{NULL}.
}
\description{
This function is identical to base R's \code{\link[base:message]{message}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
\dontrun{
  message("Don't say such silly things!")

  message("Don't say such silly things!", appendLF = FALSE, echo = FALSE)
}
}
\seealso{
Other handlers: 
\code{\link{debuginfo}()},
\code{\link{stop}()},
\code{\link{stopifnot}()},
\code{\link{warning}()}
}
\concept{handlers}
