% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KE_bwselection.R
\name{KE_bwselection}
\alias{KE_bwselection}
\title{KE_bwselection}
\usage{
KE_bwselection(data,bw_time,bw_subj,T1,T2)
}
\arguments{
\item{data}{A long format data matrix containing columns ordered by
time, subject ID, response, predictor1, predictor2, ...
where the measurement time of the longitudinal data should be discretized}

\item{bw_time}{A numeric vector that contains the candidate time bandwidths}

\item{bw_subj}{A numeric vector that contains the candidate trajectory bandwidths}

\item{T1}{A measurement time domain where the functional predictors are measured within}

\item{T2}{A measurement time domain where the functional response is of interest to predict}
}
\value{
A list containing 3 elements
\item{BWSelecStep}{Total SSE for each bandwidth combination}
\item{optimalBW}{A vector containing the optimal time/trajectory bandwidth}
\item{RunningTime}{Running time of the bandwidth selection}
}
\description{
Function used to perform leave-one-subject-out cross validation to select
             optimal time bandwidth (b_s) and trajectory bandwidth (b_w)
}
\examples{
\donttest{t_all = 1:50}
\donttest{T1=c(1,25);T2=c(26,50)}
\donttest{data = datagen(ntotal=350,ntest=50,t_all=t_all,t_split=25,seed=1)}
\donttest{data.sample = data$train}
\donttest{bwsele.toy = KE_bwselection(data=data.sample,}
\donttest{bw_time=c(1,2),bw_subj=c(0.1,0.5),T1=T1,T2=T2)}
\donttest{bwsele.toy$optimalBW}

}
\references{
\cite{Wang S, Kim S, Cho H, Chang W.
      Nonparametric predictive model for sparse and irregular longitudinal data. (2023+)}
}
