% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_model_manager.R
\name{register_custom_model}
\alias{register_custom_model}
\title{Register a custom model for a provider}
\usage{
register_custom_model(model_name, provider_name, model_config = list())
}
\arguments{
\item{model_name}{Character string, unique identifier for the model}

\item{provider_name}{Character string, name of the registered provider}

\item{model_config}{List of model-specific configuration parameters}
}
\value{
Invisibly returns TRUE if registration is successful
}
\description{
Register a custom model for a provider
}
\examples{
\dontrun{
register_custom_model(
  model_name = "my_model",
  provider_name = "my_provider",
  model_config = list(
    temperature = 0.7,
    max_tokens = 2000
  )
)
}
}
