% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{federal_election_results}
\alias{federal_election_results}
\title{Canadian federal election results data}
\format{A data.frame with 37111 rows and 12 variables:
\describe{
  \item{riding_name_english}{Federal electoral district name in English.}
  \item{riding_name_french}{Federal electoral district name in French.}
  \item{riding_code}{Uniquely identifies a federal electoral district (composed of the
              2-digit province/territory unique identifier followed by the
              3-digit federal electoral district code).}
  \item{pr}{Province or territory name (English and French).}
  \item{population}{Population of federal riding.}
  \item{voter_turnout}{Voter turnout}
  \item{candidate}{Name of winning candidate}
  \item{election_year}{Year of election (1997, 2000, 2004, 2006, 2008, 2011, and 2015 election included.)}
  \item{party}{Winning party in riding}
  \item{pr_alpha}{Province or territory 2-letter identifier}
  \item{pr_french}{Province or territory name (French).}
  \item{pr_english}{Province or territory name (English).}
  \item{pr_sgc_code}{Province Standard Geographical Classification
                           (SGC) code.}
}}
\source{
\url{http://www.elections.ca/content.aspx?section=ele&dir=pas&document=index&lang=e},
(under Open Government Licence \url{https://open.canada.ca/en/open-government-licence-canada})
}
\usage{
federal_election_results
}
\description{
A data set with information on Canadian federal election results, dating back to 1997
}
\keyword{datasets}
