% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hfp.R
\name{humanfootprint_indicator}
\alias{humanfootprint_indicator}
\alias{calc_humanfootprint}
\title{Calculate human footprint statistics}
\usage{
calc_humanfootprint(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
}
\value{
A function that returns an indicator tibble the \code{humanfootprint}
as variable and the associated value (unitless) per year.
}
\description{
Human footprint data measures the pressure imposed on the natural environment
by different dimensions of human actions. The theoretical maximum value,
representing the highest level of human pressure, is 50. This routine allows
to extract zonal statistics of the human footprint data.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{humanfootprint_resource}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_humanfootprint(years = 2010)) \%>\%
  calc_indicators(calc_humanfootprint(stats = "median")) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
