% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{taajama2019}
\alias{taajama2019}
\title{A data set containing map of Finland with urbanisation category boundaries}
\format{
A data frame with map boundaries:
\describe{
\item{ kr_name}{ Name of urbanisation category}
\item{ kr_code }{ Code of urbanisation category}
\item{geom}{Map polygon}
}
}
\source{
\url{http://geo.stat.fi/geoserver/}
}
\usage{
taajama2019
}
\description{
A data set containing map of Finland with with urbanisation category boundaries
}
\examples{
\dontrun{
library(ggplot2)
ggplot(taajama2019) +geom_sf(aes(fill = kr_name))+
labs(fill = "Kaupunkimaisuus")+
  theme(legend.title = element_text(size = 6),legend.text = element_text(size=6),
  legend.key.size = unit(10, "pt"),legend.key.width = unit(4,"pt"),
  legend.key.height = unit(4,"pt"),
   legend.position = c(0.22,0.52))
   }
}
\keyword{datasets}
