% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_get_pal.R
\name{mf_get_pal}
\alias{mf_get_pal}
\title{Get color palettes}
\usage{
mf_get_pal(
  n,
  palette,
  alpha = NULL,
  rev = c(FALSE, FALSE),
  neutral,
  breaks,
  mid
)
}
\arguments{
\item{n}{the number of colors (>= 1) to be in the palette}

\item{palette}{a valid palette name. See \link{hcl.pals} to get available
palette names. The name is matched
to the list of available palettes, ignoring upper vs. lower case, spaces,
dashes, etc. in the matching.}

\item{alpha}{an alpha-transparency level in the range [0,1] (0 means
transparent and 1 means opaque)}

\item{rev}{logical indicating whether the ordering of the colors should be
reversed}

\item{neutral}{a color, if two gradients are used, the 'neutral' color can be
added between them}

\item{breaks}{a vector of class limit}

\item{mid}{a numeric value use to divide the palette in two colors}
}
\value{
A vector of colors.
}
\description{
\code{mf_get_pal} builds sequential, diverging and
qualitative color palettes.
Diverging color palettes can be dissymmetric (different number of colors in
each of the two gradients).
}
\examples{
cls <- mf_get_pal(n = c(3, 7), palette = c("Reds 2", "Greens"))
plot(1:10, rep(1, 10), bg = cls, pch = 22, cex = 4)
mtq <- mf_get_mtq()
bks <- mf_get_breaks(mtq$MED, breaks = "equal", nbreaks = 8)
pal <- mf_get_pal(
  breaks = bks, mid = 15000,
  palette = c("Dark Mint", "Burg"), neutral = "grey90"
)
mf_map(mtq, "MED", "choro", breaks = bks, pal = pal)
pal <- mf_get_pal(breaks = bks, mid = bks[4], palette = c("Dark Mint", "Burg"))
mf_map(mtq, "MED", "choro", breaks = bks, pal = pal)
}
