% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_track.R
\name{scan_track}
\alias{scan_track}
\title{scan_track}
\usage{
scan_track(track = NULL, time, x, y = NULL, layout = NULL,
  auto.par = NULL, col = 1, alpha = 0.5, cex = 0.5, ...)
}
\arguments{
\item{track}{a \code{track} class object, or any data-frame that contains (at least) three columns labeled "T", "X" and "Y"}

\item{time}{time (can be a \code{\link{POSIXt}})}

\item{x}{x Coordinate. x,y coordiantes an be two separate vectors OR a complex "x" OR a two-column matrix/date-frame.}

\item{y}{y coordinate.}

\item{layout}{the default layout places the x-y plot on the left and the respective 1-d time series on the right.}

\item{auto.par}{by default, uses a decent looking default layout.  Otherwise can be a \code{\link{par}} list, or, e.g. FALSE to keep externally defined settings.}

\item{col}{color vector t}

\item{alpha}{intensity of the color}

\item{cex}{character expansion of the points}

\item{...}{options to be passed to plot functions}
}
\description{
Plotting x-y, time-x, time-y scan of a track.  This function will take x, y, and time coordinates or a \code{track} class object
}
\examples{

## Roe deer data

data(Michela)
par(bty="l", mar = c(0,4,0,2), oma=c(4,0,4,0), xpd=NA) 
with(Michela, scan_track(time = time, x = x, y = y, main="Michela"))

## Simulated track

time <- 1:200
Mean <- getMu(T = time, p.m = c(x1 = 0, y1 = 0, x2 = 10, y2 = 10, t1 = 90, dt = 20))
SimTrack <- simulate_shift(T = time, tau = c(tau.z = 5), mu = Mean, A = 40)
with(SimTrack, scan_track(time = T, x = X, y = Y))

# OR (because SimTrack is a "track")
scan_track(SimTrack)
}
