% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHM.test.R
\name{PHM.test}
\alias{PHM.test}
\title{Cox PH global test for checking the Markov condition on Multi-state 
Models.}
\usage{
PHM.test(data, from, to)
}
\arguments{
\item{data}{A data frame in long format containing the subject \code{id};
\code{from} corresponding to the starting state;the receiving state, 
\code{to}; the transition number, \code{trans}; the  starting time of the 
transition given by \code{Tstart}; the stopping time of the transition, 
\code{Tstop}, and \code{status} for the  status variable, with 1 indicating
an event (transition), 0 a censoring.}

\item{from}{The starting state of the transition to check the Markov 
condition.}

\item{to}{The last state of the considered transition to check the 
Markov condition.}
}
\value{
An object with a list with the following outcomes:
\item{p.value}{p-value of Cox global tests for each transition.} 
\item{from}{The starting state of the transition to check the Markov 
condition.}
\item{to}{The last state of the considered transition to check the 
Markov condition.}
}
\description{
This function is used to obtain a global test to check the 
Markov condition for each transition based on Cox Proportional hazard models.
}
\examples{
library(markovMSM)
data("colonMSM")
db_wide<-colonMSM
positions<-list(c(2, 3), c(3), c())
namesStates =  c("Alive", "Rec",  "Death")
tmat <-transMatMSM(positions, namesStates)
timesNames = c(NA, "time1","Stime")
status=c(NA, "event1","event")
trans = tmat
db_long<- prepMSM(data=db_wide, trans, timesNames, status)
res1<-PHM.test(data=db_long, from = 2, to=3)
res1

data("ebmt4")
db_wide <- ebmt4
positions=list(c(2, 3, 5, 6), c(4, 5, 6), c(4, 5, 6),
               c(5, 6), c(6), c())
namesStates = c("Tx", "Rec", "AE", "Rec+AE", "Rel", "Death")
tmat <-transMatMSM(positions, namesStates)
timesNames = c(NA, "rec", "ae","recae", "rel", "srv")
status=c(NA, "rec.s", "ae.s", "recae.s","rel.s", "srv.s")
trans = tmat
db_long<- prepMSM(data=db_wide, trans, timesNames, status)
db_long$trans<-as.factor(db_long$trans)
res2<-PHM.test(data=db_long, from = 5, to=6)
res2$p.value
res2$from
res2$to
}
\references{
Kay, R (1986). A Markov model for analyzing cancer markers and 
disease states in survival studies. \emph{Biometrics} 42, 457-481.
Soutinho G, Meira-Machado L (2021). Methods for checking the Markov condition
in multi-state survival data. \emph{Computational Statistics}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado.
}
