% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct.R
\name{as_matrixset}
\alias{as_matrixset}
\title{Coerce object into \code{matrixset}}
\usage{
as_matrixset(
  x,
  expand = NULL,
  row_info = NULL,
  column_info = NULL,
  row_key = "rowname",
  column_key = "colname",
  row_tag = ".rowname",
  column_tag = ".colname"
)
}
\arguments{
\item{x}{an object to coerce to \code{matrixset}. See methods.}

\item{expand}{By default (\code{NULL}), input matrix expansion is disabled.
Setting this parameter to \code{TRUE} will enable the expansion
feature. See the section \sQuote{Matrix Expansion} of
\code{\link[=matrixset]{matrixset()}} for more details of what it is, as well as
other possible options for \code{expand}. Note as well that this
argument is not available for all methods.}

\item{row_info}{a data frame, used to annotate matrix rows. The link
between the matrix row names and the data frame is given
in column "rowname". A different column can be used if one
provides a different \code{row_key}.}

\item{column_info}{a data frame, used to annotate matrix columns. The link
between the matrix column names and the data frame is given
in column "colname". A different column can be used if one
provides a different \code{column_key}.}

\item{row_key}{column name in \code{row_info} data frame that will
link the row names with the row information. A string is
expected.}

\item{column_key}{column name in \code{col_info} data frame that will
link the column names with the row information. A string is
expected.}

\item{row_tag}{A string, giving the row annotation data frame column that
will link the row names to the data frame. While
\code{row_key} specifies the column name of the data frame
at input, \code{row_tag} specifies the column name that
will be used throughout in the \code{matrixset} object.}

\item{column_tag}{A string, giving the column annotation data frame column
that will link the row names to the data frame. While
\code{column_key} specifies the column name of the data
frame at input, \code{column_tag} specifies the column
name that will be used throughout in the \code{matrixset}
object.}
}
\value{
Returns a \code{matrixset} - see \code{\link[=matrixset]{matrixset()}}.
}
\description{
Turns object into a \code{matrixset}. See specific methods for more details
}
\section{Methods}{

\itemize{
\item \code{matrix}

The \code{matrix} method is very similar to calling the \code{matrixset}
construction function, with some key differences:
\itemize{
\item A matrix name will be provided automatically by \code{as_matrixset}. The
name is "..1".
\item Because only matrix is provided, the \code{expand} argument is not available
}
\item \code{list}

The \code{list} method is nearly identical to calling the \code{matrixset}
construction function. It only differs in that unnamed \code{list} element
will be padded with a name. The new padded names are the element index,
prefixed by "..". Already existing names will be made unique as well. If
name modification needs to be performed, a warning will be issued.
}
}

\examples{
# We're showing how 'as_matrixset' can differ. But first, show how they can
# yield the same result. Note that the list is named
lst <- list(a = matrix(1:6, 2, 3), b = matrix(101:106, 2, 3))
identical(matrixset(lst), as_matrixset(lst))

# Now it will differ: the list is unnamed. In fact, 'matrixset' will fail
lst <- list(matrix(1:6, 2, 3), matrix(101:106, 2, 3))
is(try(matrixset(lst), silent = TRUE), "try-error")
as_matrixset(lst)

# You need to name the matrix to use 'matrixset'. A name is provided for you
# with 'as_matrixset'. But you can't control what it is.
as_matrixset(matrix(1:6, 2, 3))

}
