% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_record}
\alias{search_record}
\title{Search and Filter Records in a literature matrix}
\usage{
search_record(.data, column = NULL, where = NULL)
}
\arguments{
\item{.data}{A data frame to search within.}

\item{column}{Optional. The column to search in, specified either by name or numeric index.
If NULL (default), the search is performed across all columns.}

\item{where}{A logical expression that defines the search condition.
Must evaluate to a logical vector of the same length as the number of rows in `.data`.}
}
\value{
A filtered data frame containing only the rows that match the search condition.
        If a specific column was selected, only that column is returned.
}
\description{
Filters a literature matrix based on a specified condition, with the option to restrict the search
to a specific column. The function supports both column names and numeric indices for column selection.
}
\examples{
df <- data.frame(
  id = 1:5,
  name = c("John", "Jane", "Bob", "Alice", "John"),
  age = c(25, 30, 35, 28, 40)
)

# Search across all columns where age > 30
search_record(df, where = age > 30)

# Search only in the name column for "John"
search_record(df, column = "name", where = name == "John")

# Search using column index
search_record(df, column = 2, where = name == "Jane")

}
