% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read.Utilities.R
\name{Read.Utilities}
\alias{Read.Utilities}
\title{Read utilities}
\usage{
Read.Utilities(file, script, lines, skip = 2, encoding = "utf-8")
}
\arguments{
\item{file}{standardize file with definitions.}

\item{script}{output script where the utility functions are defined automatically.}

\item{lines}{number lines to read in \code{file}.}

\item{skip}{to read the \code{file} it had to \code{skip} a given number of lines.}

\item{encoding}{file encoding.}
}
\value{
Returns data table with definition of utility functions by range.
}
\description{
Builds utility functions from definition standard.
}
\details{
The basic MAUT models are built with functions of constant absolute risk aversion, 
this functions could be defined with simple parameters, only is necessary a function name and
the domain of definition of every function and more important is necessary no more than three
coefficients for the function definition.
}
\examples{
library( data.table )
file<-system.file("extdata", "utilities.txt", package = "mau" )
script<-'utilities.R'
lines<-17
skip<-2
encoding<-'utf-8'
functions<-Read.Utilities( file, script, lines, skip, encoding )
}
\seealso{
\code{\link{Stand.String}}
}
\author{
Pedro Guarderas, Andrés Lopez
}
