% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapSE.R
\name{bootstrapSE}
\alias{bootstrapSE}
\title{Bootstrap to get standard errors}
\usage{
bootstrapSE(
  tab,
  n_rep = 1000,
  interval = c(0, 1),
  tol = 0.000001,
  check_boundary = FALSE,
  cores = 1,
  return_raw = FALSE
)
}
\arguments{
\item{tab}{Dataset of read counts as 3d array of size 3x3x2, genotype in first sample x genotype in second sample x allele in read.}

\item{n_rep}{Number of bootstrap replicates}

\item{interval}{Interval to which each parameter should be constrained}

\item{tol}{Tolerance for convergence}

\item{check_boundary}{If TRUE, explicitly check the boundaries of \code{interval}.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}

\item{return_raw}{If TRUE, return the raw results. If FALSE, just return the estimated standard errors.}
}
\value{
If \code{return_raw=FALSE}, a vector of two standard errors. If
\code{return_raw=TRUE}, an matrix of size \code{n_rep} x 2 with the detailed
bootstrap results.
}
\description{
Perform a parametric bootstrap to get estimated standard errors.
}
\examples{
data(mbmixdata)
# just 100 bootstrap replicates, as an illustration
bootstrapSE(mbmixdata, n_rep=100)

}
\seealso{
\code{\link[=bootstrapNull]{bootstrapNull()}}
}
