% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mccf1.R
\name{summary.mccf1}
\alias{summary.mccf1}
\title{Summarize the the performance of a binary classification using MCC-F1 metric and the best threshold}
\usage{
\method{summary}{mccf1}(object, digits, bins = 100, ...)
}
\arguments{
\item{object}{S3 object of class "mccf1" object resulting from the function `mccf1()`}

\item{digits}{integer, used for number formatting with \code{\link[base]{signif}}}

\item{bins}{integer, representing number of bins used to divide up the range of normalized MCC
when calculating the MCC-F1 metric (default = 100L)}

\item{...}{other arguments ignored (for compatibility with generic)}
}
\value{
data.frame that shows the MCC-F1 metric (in the range [0,1]) and the best threshold (in the range [0,1])
}
\description{
`summary.mccf1()` calculates the MCC-F1 metric and the best threshold for a binary classification.
}
\examples{
response <- c(rep(1L, 1000L), rep(0L, 10000L))
set.seed(2017)
predictor <- c(rbeta(300L, 12, 2), rbeta(700L, 3, 4), rbeta(10000L, 2, 3))
\dontrun{summary(mccf1(response, predictor))}
# mccf1_metric best_threshold
#    0.3508904       0.786905
summary(mccf1(response, predictor), bins = 50)
# mccf1_metric best_threshold
#    0.3432971       0.786905
\dontrun{summary(mccf1(response, predictor), digits = 3)}
# mccf1_metric best_threshold
#    0.351          0.787
}
