% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/fnames.R, R/freqlist.R,
%   R/tokenize.R, R/types.R
\name{brackets}
\alias{brackets}
\alias{[.fnames}
\alias{[<-.fnames}
\alias{[.freqlist}
\alias{[.tokens}
\alias{[<-.tokens}
\alias{[.types}
\alias{[<-.types}
\title{Subset an object by different criteria}
\usage{
\method{[}{fnames}(x, i, invert = FALSE, ...)

\method{[}{fnames}(x, i, invert = FALSE) <- value

\method{[}{freqlist}(x, i, invert = FALSE, ...)

\method{[}{tokens}(x, i, invert = FALSE, ...)

\method{[}{tokens}(x, i, invert = FALSE, ...) <- value

\method{[}{types}(x, i, invert = FALSE, ...)

\method{[}{types}(x, i, invert = FALSE) <- value
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{i}{Selection criterion; depending on its class, it behaves differently.}

\item{invert}{Logical. Whether the matches should be selected rather than the
non-matches.}

\item{...}{Additional arguments.}

\item{value}{Value to assign.}
}
\value{
Object of the same class as \code{x} with the selected elements only.
}
\description{
This method can be used to subset objects based on different criteria.
}
\details{
The subsetting method with the notation \verb{[]}, applied to mclm objects,
is part of a family of subsetting methods: see \code{\link[=keep_pos]{keep_pos()}}, \code{\link[=keep_re]{keep_re()}},
\code{\link[=keep_types]{keep_types()}} and \code{\link[=keep_bool]{keep_bool()}}. In this case, the argument \code{i} is the selection
criterion and, depending on its class, the method behaves different:
\itemize{
\item providing a \code{\link{re}} object is equivalent to calling \code{\link[=keep_re]{keep_re()}},
\item providing a numeric vector is equivalent to calling \code{\link[=keep_pos]{keep_pos()}},
\item providing a logical vector is equivalent to calling \code{\link[=keep_bool]{keep_bool()}},
\item providing a \code{\link{types}} object or a character vector is equivalent to calling \code{\link[=keep_types]{keep_types()}}.
}

When the notation \code{x[i, ...]} is used, it is also possible to set the \code{invert}
argument to \code{TRUE} (which then is one of the additional arguments in \code{...}).
This \code{invert} argument then serves the same purpose as the \code{invert} argument
in the \code{keep_} methods, turning it into a \code{drop_} method.
}
\examples{
# For a 'freqlist' object --------------------
(flist <- freqlist("The man and the mouse.", as_text = TRUE))

## like keep_re()
flist[re("[ao]")]
flist[re("[ao]"), invert = TRUE]

## like keep_pos()
flist[type_freqs(flist) < 2]
flist[ranks(flist) <= 3]
flist[ranks(flist) <= 3, invert = TRUE]
flist[2:3]

## like keep_bool()
(flist2 <- keep_bool(flist, type_freqs(flist) < 2))
flist2[orig_ranks(flist2) > 2]

## like keep_types()
flist[c("man", "and")]
flist[as_types(c("man", "and"))]

# For a 'types' object -----------------------
(tps <- as_types(letters[1:10]))

tps[c(1, 3, 5, 7, 9)]
tps[c(TRUE, FALSE)]
tps[c("a", "c", "e", "g", "i")]

tps[c(1, 3, 5, 7, 9), invert = TRUE]
tps[c(TRUE, FALSE), invert = TRUE]
tps[c("a", "c", "e", "g", "i"), invert = TRUE]

# For a 'tokens' object ----------------------
(tks <- as_tokens(letters[1:10]))

tks[re("[acegi]"), invert = TRUE]
tks[c(1, 3, 5, 7, 9), invert = TRUE]
tks[c(TRUE, FALSE), invert = TRUE]
tks[c("a", "c", "e", "g", "i"), invert = TRUE]
}
\seealso{
Other subsetters: 
\code{\link{keep_bool}()},
\code{\link{keep_pos}()},
\code{\link{keep_re}()},
\code{\link{keep_types}()}
}
\concept{subsetters}
