% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/slma.R
\name{details}
\alias{details}
\alias{details.slma}
\title{Details on a specific item}
\usage{
details(x, y, ...)

\method{details}{slma}(x, y, shorten_names = TRUE, ...)
}
\arguments{
\item{x}{An object containing global statistics for a collection of linguistic units,
such as an object of class \code{\link{slma}}.}

\item{y}{A character vector of length one representing one linguistic item.}

\item{...}{Additional arguments.}

\item{shorten_names}{Logical. If \code{TRUE}, filenames in the rownames are
shortened with \code{\link[=short_names]{short_names()}}.}
}
\value{
An object with details. When \code{x} is of class \code{\link{slma}},
the class of the output is \code{details.slma}, namely a list with the following items:
\itemize{
\item \code{summary}: The row of \code{x$scores} corresponding to \code{y}.
\item \code{scores} (what is printed by default), a dataframe with one row per
pair of documents in the \code{\link{slma}} and the frequencies and association scores of
the chosen item as columns.
\item \code{item}: the value of \code{y}.
\item \code{sig_cutoff} and \code{small_pos}, as defined in \code{\link{slma}}.
}
}
\description{
This method zooms in on details of an object \code{x} based on an item \code{y}.
When \code{x} is of class \code{\link{slma}} (currently the only supported class),
\code{y} must be one of the lexical markers described in it.
}
\examples{
a_corp <- get_fnames(system.file("extdata", "cleveland", package = "mclm"))
b_corp <- get_fnames(system.file("extdata", "roosevelt", package = "mclm"))
slma_ex <- slma(a_corp, b_corp, keep_intermediate = TRUE)

gov <- details(slma_ex, "government")
gov$summary

# A bit of tidy manipulation to shorten filenames
if (require("dplyr") && require("tidyr")) {
  as_tibble(gov, rownames = "files") \%>\% 
     tidyr::separate(files, into = c("file_A", "file_B"), sep = "--") \%>\% 
     dplyr::mutate(dplyr::across(dplyr::starts_with("file"), short_names))
} 
}
