% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.R, R/conc.R, R/fnames.R, R/freqlist.R,
%   R/generics.R, R/slma.R, R/tokenize.R, R/types.R
\name{print.assoc_scores}
\alias{print.assoc_scores}
\alias{print.conc}
\alias{print.fnames}
\alias{print.freqlist}
\alias{mclm_print}
\alias{print.slma}
\alias{print.tokens}
\alias{print.types}
\title{Print an object}
\usage{
\method{print}{assoc_scores}(
  x,
  n = 20,
  from = 1,
  freeze_cols = NULL,
  keep_cols = NULL,
  drop_cols = NULL,
  from_col = 1,
  sort_order = c("none", "G_signed", "PMI", "alpha"),
  extra = NULL,
  ...
)

\method{print}{conc}(x, n = 30, ...)

\method{print}{fnames}(
  x,
  n = 20,
  from = 1,
  sort_order = c("none", "alpha"),
  extra = NULL,
  hide_path = NULL,
  ...
)

\method{print}{freqlist}(x, n = 20, from = 1, extra = NULL, ...)

\method{print}{slma}(x, n = 20, from = 1, ...)

\method{print}{tokens}(x, n = 20, from = 1, extra = NULL, ...)

\method{print}{types}(x, n = 20, from = 1, sort_order = c("none", "alpha"), extra = NULL, ...)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{n}{Maximum number of items in the object to be printed at once.}

\item{from}{Index of the first item to be printed.}

\item{freeze_cols}{Names of columns that should not be affected by the argument
\code{from_col}. Frozen columns are always printed to the left of non-frozen
columns, even if in their original order was different. The names of the types
are always and unavoidably printed as the leftmost column.

If this argument is \code{NULL}, then the default setting applies, meaning that
the following columns, if present, are displayed in the "frozen area": \code{a},
\code{PMI} and \code{G_signed}.

To avoid any columns for being frozen, \code{freeze_cols} should be \code{NA} or
\code{character(0)}.}

\item{keep_cols, drop_cols}{A vector of column names or \code{NULL}. If both arguments
are \code{NULL}, all columns are printed (or as many as fit on the screen). If
\code{keep_cols} is not \code{NULL}, it indicates the columns that should be printed.
If it is \code{NULL} but \code{drop_cols} is not, then \code{drop_cols} indicates the columns
that should \emph{not} be printed. Note that they have \strong{no effect} on the frozen area.

Columns that are blocked from printing by these arguments are still available
to \code{sort_order}.}

\item{from_col}{Index of the first column to be displayed in the regular area
(among all selected columns, including frozen columns). If \code{from_col} points}

\item{sort_order}{Order in which the items are to be printed. In general, possible values
are \code{"alpha"} (meaning that the items are to be sorted alphabetically),
and \code{"none"} (meaning that the items are not to be sorted).
If \code{x} is an object of class \code{\link{assoc_scores}}, a column name
or vector of column names may be provided instead.}

\item{extra}{Extra settings, as an \link{environment}. Arguments defined here
take precedence over other arguments. For instance, if \code{extra$from_col} is
not \code{NULL}, it will overrule the \code{from_col} argument.}

\item{...}{Additional printing arguments.}

\item{hide_path}{A character string with a regular expression or \code{NULL}. If it is
not \code{NULL}, the character string will be removed from the paths when printing.}
}
\value{
Invisibly, \code{x}.
For objects of class \code{assoc_scores}, the output consists of two areas:
the 'frozen area' on the left and the 'regular area' on the right. Both
areas are visually separated by a vertical line (\code{|}). The distinction between
them is more intuitive in \code{\link[=explore]{explore()}}, where the frozen columns do not respond
to horizontal movements (with the \code{r} and \code{l} commands). The equivalent in
this method is the \code{from_col} argument.
}
\description{
This base method prints objects; here the arguments specific to mclm
implementations are described.
}
