% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.R
\name{re_convenience}
\alias{re_convenience}
\alias{re_retrieve_first}
\alias{re_retrieve_last}
\alias{re_retrieve_all}
\alias{re_has_matches}
\alias{re_which}
\alias{re_replace_first}
\alias{re_replace_all}
\title{Convenience functions in support of regular expressions}
\usage{
re_retrieve_first(
  x,
  pattern,
  ignore.case = FALSE,
  perl = TRUE,
  fixed = FALSE,
  useBytes = FALSE,
  requested_group = NULL,
  drop_NA = FALSE,
  ...
)

re_retrieve_last(
  x,
  pattern,
  ignore.case = FALSE,
  perl = TRUE,
  fixed = FALSE,
  useBytes = FALSE,
  requested_group = NULL,
  drop_NA = FALSE,
  ...
)

re_retrieve_all(
  x,
  pattern,
  ignore.case = FALSE,
  perl = TRUE,
  fixed = FALSE,
  useBytes = FALSE,
  requested_group = NULL,
  unlist = TRUE,
  ...
)

re_has_matches(
  x,
  pattern,
  ignore.case = FALSE,
  perl = TRUE,
  fixed = FALSE,
  useBytes = FALSE,
  ...
)

re_which(
  x,
  pattern,
  ignore.case = FALSE,
  perl = TRUE,
  fixed = FALSE,
  useBytes = FALSE,
  ...
)

re_replace_first(
  x,
  pattern,
  replacement,
  ignore.case = FALSE,
  perl = TRUE,
  fixed = FALSE,
  useBytes = FALSE,
  ...
)

re_replace_all(
  x,
  pattern,
  replacement,
  ignore.case = FALSE,
  perl = TRUE,
  fixed = FALSE,
  useBytes = FALSE,
  ...
)
}
\arguments{
\item{x}{Character vector to be searched or modified.}

\item{pattern}{Regular expression specifying what is to be searched.}

\item{ignore.case}{Logical. Should the search be case insensitive?}

\item{perl}{Logical. Whether the regular expressions use the PCRE flavor
of regular expression. Unlike in base R functions, the default is \code{TRUE}.}

\item{fixed}{Logical. If \code{TRUE}, \code{pattern} is a string to be matched as is,
i.e. wildcards and special characters are not interpreted.}

\item{useBytes}{Logical. If \code{TRUE} the matching is done byte-by-byte rather than
character-by-character. See 'Details' in \code{\link[=grep]{grep()}}.}

\item{requested_group}{Numeric.
If \code{NULL} or \code{0}, the output will contain matches for \code{pattern} as a whole.
If another number \code{n} is provided, then the output will not contain matches
for \code{pattern} but instead will only contain the matches for the \code{n}th capturing
group in \code{pattern} (the first if \code{requested_group = 1}, the second if
\code{requested_group = 2}...).}

\item{drop_NA}{Logical. If \code{FALSE}, the output always has the same length as
the input \code{x} and items that do not contain a match for \code{pattern} yield \code{NA}.
If \code{TRUE}, such \code{NA} values are removed and therefore the result might contain
fewer items than \code{x}.}

\item{...}{Additional arguments.}

\item{unlist}{Logical. If \code{FALSE}, the output always has the same length as
the input \code{x}. More specifically, the result will be a list in which input
items that do not contain a match for \code{pattern} yield an empty vector, whereas
input items that do match will yield a vector of at least length one (depending
on the number of matches). If \code{TRUE}, the output is a single vector the length
of which may be shorter or longer than \code{x}.}

\item{replacement}{Character vector of length one specifying the replacement
string. It is to be taken literally, except that the notation \verb{\\\\1}, \verb{\\\\2}, etc.
can be used to refer to groups in \code{pattern}.}
}
\value{
\code{re_retrieve_first()}, \code{re_retrieve_last()} and \code{re_retrieve_all()} return
either a single vector of character data or a list containing such vectors.
\code{re_replace_first()} and \code{re_replace_all()} return the same type of character
vector as \code{x}.

\code{re_has_matches()} returns a logical vector indicating whether a match was
found in each of the elements in \code{x}; \code{re_which()} returns a numeric
vector indicating the indices of the elements of \code{x} for which a match was
found.
}
\description{
These functions are essentially simple wrappers around base R functions such as
\code{\link[=regexpr]{regexpr()}}, \code{\link[=gregexpr]{gregexpr()}}, \code{\link[=grepl]{grepl()}}, \code{\link[=grep]{grep()}}, \code{\link[=sub]{sub()}} and \code{\link[=gsub]{gsub()}}.
The most important differences between the functions documented here and the
R base functions is the order of the arguments (\code{x} before \code{pattern}) and the
fact that the argument \code{perl} is set to \code{TRUE} by default.
}
\details{
For some of the arguments (e.g. \code{perl}, \code{fixed}) the reader is directed to
\link[base:regex]{base R's regex documentation}.
}
\section{Functions}{
\itemize{
\item \code{re_retrieve_first()}: Retrieve from each item in \code{x} the first match
of \code{pattern}.

\item \code{re_retrieve_last()}: Retrieve from each item in \code{x}
the last match of \code{pattern}.

\item \code{re_retrieve_all()}: Retrieve from each item in \code{x}
all matches of \code{pattern}.

\item \code{re_has_matches()}: Simple wrapper around \code{\link[=grepl]{grepl()}}.

\item \code{re_which()}: Simple wrapper around \code{\link[=grep]{grep()}}.

\item \code{re_replace_first()}: Simple wrapper around \code{\link[=sub]{sub()}}.

\item \code{re_replace_all()}: Simple wrapper around \code{\link[=gsub]{gsub()}}.

}}
\examples{
x <- tokenize("This is a sentence with a couple of words in it.")
pattern <- "[oe](.)(.)"

re_retrieve_first(x, pattern)
re_retrieve_first(x, pattern, drop_NA = TRUE)
re_retrieve_first(x, pattern, requested_group = 1)
re_retrieve_first(x, pattern, drop_NA = TRUE, requested_group = 1)
re_retrieve_first(x, pattern, requested_group = 2)

re_retrieve_last(x, pattern)
re_retrieve_last(x, pattern, drop_NA = TRUE)
re_retrieve_last(x, pattern, requested_group = 1)
re_retrieve_last(x, pattern, drop_NA = TRUE, requested_group = 1)
re_retrieve_last(x, pattern, requested_group = 2)

re_retrieve_all(x, pattern)
re_retrieve_all(x, pattern, unlist = FALSE)
re_retrieve_all(x, pattern, requested_group = 1)
re_retrieve_all(x, pattern, unlist = FALSE, requested_group = 1)
re_retrieve_all(x, pattern, requested_group = 2)

re_replace_first(x, "([oe].)", "{\\\\1}")
re_replace_all(x, "([oe].)", "{\\\\1}")
}
