% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnames.R
\name{write_fnames}
\alias{write_fnames}
\title{Write a collection of filenames to a text file}
\usage{
write_fnames(x, file, ...)
}
\arguments{
\item{x}{Object of class \code{\link{fnames}}.}

\item{file}{Path to output file.}

\item{...}{Additional arguments (not implemented).}
}
\value{
Invisibly, \code{x}.
}
\description{
This function writes an object of class \code{\link{fnames}} to a text file. Each filename
is written in a separate line. The file encoding is always \code{"UTF-8"}.
In addition, it can store metadata in an additional configuration file.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
cwd_fnames <- as_fnames(c("file1.txt", "file2.txt"))
write_fnames(cwd_fnames, "file_with_filenames.txt")
cwd_fnames_2 <- read_fnames("file_with_filenames.txt")
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=read_fnames]{read_fnames()}}

Other writing functions: 
\code{\link{write_assoc}()},
\code{\link{write_conc}()},
\code{\link{write_freqlist}()},
\code{\link{write_tokens}()},
\code{\link{write_txt}()},
\code{\link{write_types}()}
}
\concept{writing functions}
