% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeTrees.R
\name{mergeTrees}
\alias{mergeTrees}
\title{Merge a set of hclust objet into a single tree}
\usage{
mergeTrees(hc.list, standardize = FALSE)
}
\arguments{
\item{hc.list}{a list with at least one hclust object to be merge in a single consensus tree. No other tree format is supported. The trees should have the same leaves labels, otherwise the function will stop.}

\item{standardize}{a boolean indicating wether the heights of the different trees should be normalized before merged. Normalization is done by divinding the heights of fusion by their maximum in each tree.}
}
\value{
A list of class hclust, being the consensus tree, with the following components: height, merge, method, order, and, if any, labels. For more information about these components, please see hclust function help page.
}
\description{
The consensus tree is built from top to bottom. Trees from hc.list argument are transformed into a list of possible splits. Each split is characterized by its heights in the tree and
the two clusters it is creating. If the trees are non-binary trees (i.e. create more than two clusters in one split, or equivalently, if they merge more than two clusters), the method creates as many splits as
there are clusters created.
All the splits from the trees are then ordered by decreasing height. The method follow the list to find the active splits, and create a consensus tree.
The method can be summarized with this property: "At height h, if elements i and j are groupes in the same clusters in all the trees, then they are in the same cluster in the consensus tree", or, equivalently:
"At height h, if elements i and j are not in the same clusters in at least one of the trees, then they are not in the same cluster in the consensus tree".
}
\examples{
  library(mergeTrees)
  M1 = matrix(c(0,2,3,4,2,0,1,5,3,1,0,7,4,5,7,0), ncol = 4, nrow = 4)
  M2 = matrix(c(0,1,5,6,1,0,7,9,5,7,0,2,6,9,2,0), ncol = 4, nrow = 4)
  h1 = hclust(as.dist(M1))
  h2 = hclust(as.dist(M2))
  MT = mergeTrees(list(h1, h2))
  oldpar <- par(mfrow = c(1,3))
  plot(h1)
  plot(h2)
  plot(MT)
  par(oldpar)
}
\author{
Audrey Hulot, \email{audrey.hulot@inra.fr}, Julien Chiquet, Guillem Rigaill
}
