% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabup.R
\name{metabup}
\alias{metabup}
\title{Bayesian meta-analysis using basic uncertain pooling.}
\usage{
metabup(y, nv, type = NULL, d2max = NULL, ngrid2 = NULL, N = NULL)
}
\arguments{
\item{y}{vector of counts or effect estimates.}

\item{nv}{vector of total counts n (if y's are counts) or variances associated with the estimates(if y's are estimates).}

\item{type}{assumes a single value: 1 (counts and total counts as inputs) or 2 (estimates and variances as inputs). Default is type 2.}

\item{d2max}{maximum value of the prior variance delta^2  to be used in the grid sampling. Default is .Machine$double.xmin.}

\item{ngrid2}{number of grid points for the prior variance. Default is 1000 if d2max > .Machine$double.xmin.}

\item{N}{sample size to be drawn from the partition-delta^2 grid. Default is 1000.}
}
\value{
list consisting of the sample and posterior effect estimates and standard deviations, the partitions with the largest posterior probabilities, and the similarity matrix.
}
\description{
Bayesian meta-analysis analysis  (1) with binomial data, counts(y) and total counts (n) or, (2) with user-supplied estimates and associated variances.  Case (1) provides an analysis based on the logit transformation of the sample proportion. This methodology is also appropriate for combining data from sample surveys and related sources.
}
\examples{


y=c(4, 18, 40, 130)
nv=c(13, 83, 60,166)
require(partitions)
out=metabup(y, nv, type=1)

#estimates
out[1]
#the partitions with the largest posterior p(g|y)
out[2:3]

#plotting similarity matrix
require(ggplot2)
L=length(y)
indmat=matrix(unlist(out[4]),ncol=L, byrow=FALSE)
psingle<-rep(0,L)
sim_mat<-indmat +t(indmat)
diag(sim_mat)<-psingle #rep(1,L)
xy=expand.grid(x=1:L, y=1:L)
index=as.vector( sim_mat)
mat_data =  cbind(xy,index)
brlab<-round(seq(0, max(sim_mat)+0.05, length.out=4),2)
p <- ggplot(data = mat_data) +                        # Set data
geom_tile(aes(x = x, y = y, fill =index)) +
scale_fill_gradientn(colours=rev(heat.colors(5)),na.value = "transparent",
                      breaks=brlab,labels=brlab,
                      limits=c(0,max(sim_mat)+0.075))+
scale_x_continuous(name="Study Number", breaks=1:L,   limits=c(0.5,+L+0.5)) +
scale_y_continuous(name="", breaks=1:L,  limits=c(0.5,L+0.5))
p + theme(axis.title  = element_text() )



ph=c(31, 21.7, 66.7,78.3)/100
y=log(ph/(1-ph))
n=c(13, 83, 60,166)
nv=1/(ph*(1-ph)*n)  #variance
require(partitions)
out=metabup(y, nv)

#estimates
out[1]
#the partitions with the largest posterior p(g|y)
out[2:3]

#plotting similarity matrix
require(ggplot2)
L=length(y)
indmat=matrix(unlist(out[4]),ncol=L, byrow=FALSE)
psingle<-rep(0,L)
sim_mat<-indmat +t(indmat)
diag(sim_mat)<-psingle #rep(1,L)
xy=expand.grid(x=1:L, y=1:L)
index=as.vector( sim_mat)
mat_data =  cbind(xy,index)
brlab<-round(seq(0, max(sim_mat)+0.05, length.out=4),2)
p <- ggplot(data = mat_data) +                        # Set data
geom_tile(aes(x = x, y = y, fill =index)) +
scale_fill_gradientn(colours=rev(heat.colors(5)),na.value = "transparent",
                      breaks=brlab,labels=brlab,
                      limits=c(0,max(sim_mat)+0.075))+
scale_x_continuous(name="Study Number", breaks=1:L,   limits=c(0.5,+L+0.5)) +
scale_y_continuous(name="", breaks=1:L,  limits=c(0.5,L+0.5))
p + theme(axis.title  = element_text() )



}
\references{
Cahoy and Sedransk (2023). \emph{Combining data from surveys and related sources.}  Surv. Methodol., To appear.

Cahoy and Sedransk (2022). \emph{Bayesian inference for asymptomatic COVID-19 infection rates.}  Stat Med, 41(16):3131-3148,
<doi:10.1002/sim.9408>

Evans and Sedransk (2001). \emph{Combining data from experiments that may be similar.} Biometrika, 88(3):643-656,
<doi:10.1093/biomet/88.3.643>

Malec and Sedransk (1992). \emph{Bayesian methodology for combining the results from different experiments when the specifications for pooling are uncertain}. Biometrika, 79(3):593-601,
<doi:10.1093/biomet/79.3.593>
}
