% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{fes2d21d}
\alias{fes2d21d}
\title{Calculate 1D free energy surface from hillsfile object}
\usage{
fes2d21d(hills, remdim = 2, temp = 300, eunit = "kJ/mol", imin = 1,
  imax = NULL, xlim = NULL, ylim = NULL, npoints = 256)
}
\arguments{
\item{hills}{hillsfile object.}

\item{remdim}{dimension to be removed (1 for CV1, 2 for CV2, default 2).}

\item{temp}{temperature in Kelvins (default 300).}

\item{eunit}{energy units (kJ/mol or kcal/mol, kJ/mol is default).}

\item{imin}{index of a hill from which summation starts (default 1).}

\item{imax}{index of a hill from which summation stops (default the rest of hills).}

\item{xlim}{numeric vector of length 2, giving the CV1 coordinates range.}

\item{ylim}{numeric vector of length 2, giving the CV2 coordinates range.}

\item{npoints}{resolution of the free energy surface in number of points.}
}
\value{
fes object.
}
\description{
`fes2d21d` calculates 2D free energy surface, converts free energies to probabilities
(exp(-F/kT)), sums them up along one collective variable and converts back to free
energy (-kT log(P)).
}
\examples{
tfes<-fes2d21d(acealanme, remdim=2, imax=5000)
}
