% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.r
\name{gelmanplot.mcmc.list}
\alias{gelmanplot.mcmc.list}
\title{Gelman-Rubin-Brooks plot}
\usage{
\method{gelmanplot}{mcmc.list}(
  x,
  P,
  confidence = 0.95,
  max.bins = 50,
  autoburnin = TRUE,
  greek = FALSE,
  ...
)
}
\arguments{
\item{x}{An mcmc object}

\item{P}{Optional dataframe describing the parameters to plot and their respective names}

\item{confidence}{The coverage probability of the confidence interval for the potential scale reduction factor}

\item{max.bins}{Maximum number of bins, excluding the last one.}

\item{autoburnin}{Logical flag indicating whether only the second half of the series should be used in the computation. 
If set to TRUE (default) and start(x) is less than end(x)/2 then start of series will be adjusted so that only second half of series is used.}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}

\item{\ldots}{Additional arguments which are currently not used}
}
\value{
A \code{ggplot} object.

An object of class \code{ggplot}
}
\description{
This plot shows the evolution of Gelman and Rubin's shrink factor as the number of iterations increases. The code is adapted from
the R package coda.
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
