% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_plot.R
\name{diff_plot}
\alias{diff_plot}
\title{plot difference network}
\usage{
diff_plot(
  metanetwork,
  g1,
  g2,
  beta = 0.1,
  mode = "TL-tsne",
  vis_tool = "ggnet",
  edge_thrs = NULL,
  layout_metaweb = FALSE,
  flip_coords = FALSE,
  alpha_per_group = NULL,
  alpha_per_node = NULL,
  TL_tsne.config = TL_tsne.default,
  nrep_ly = 1,
  ggnet.config = ggnet.default,
  visNetwork.config = visNetwork.default
)
}
\arguments{
\item{metanetwork}{object of class 'metanetwork'}

\item{g1}{network (of class 'igraph') of metanetwork}

\item{g2}{network (of class 'igraph') of metanetwork}

\item{beta}{the diffusion parameter of the diffusion kernel, a positive scalar controlling the
squeezing of the network}

\item{mode}{mode used for layout, either 'TL-tsne' or 'group-TL-tsne' (see \code{attach_layout()}). Default is 'TL-tsne'}

\item{vis_tool}{a character indicating the visualisation tool, either 'ggnet' or visNetwork}

\item{edge_thrs}{if non-null, a numeric (between 0 and 1) indicating an edge threshold for the representation}

\item{layout_metaweb}{a boolean indicating whether the layout of the metaweb should be used to represent the difference network.
to use metaweb layout = T, you need first to compute 'TL-tsne' layout for the metaweb for this beta value using \code{attach_layout()}}

\item{flip_coords}{a boolean indicating whether coordinates should be flipped.
In that case, y-axis is the trophic level and x-axis is the layout axis}

\item{alpha_per_group}{controlling alpha per group (only for 'ggnet' vis), a list of format
\code{list(resolutions = "XX",groups = XX,alpha_focal = XX,alpha_hidden = XX)}, see example}

\item{alpha_per_node}{controlling alpha per node (only for 'ggnet' vis), a list of format
\code{list(nodes = XX,alpha_focal = XX,alpha_hidden = XX)}, see example}

\item{TL_tsne.config}{configuration list for mode 'TL-tsne', default is TL_tsne.default}

\item{nrep_ly}{If several layouts for this beta value are attached to the metaweb
(if \code{layout_metaweb = T}), index of the layout to use, see \code{attach_layout()}}

\item{ggnet.config}{configuration list for ggnet representation, default is ggnet.default}

\item{visNetwork.config}{configuration list for visNetwork representation, default is visNetwork.default}
}
\value{
an object of class \code{ggplot} or \code{visNetwork}, representation of the difference network
}
\description{
Function to represent difference between two networks belonging to a metanetwork
with specific layout ('TL-tsne' or group 'TL-tsne') using either 'ggnet' or 'visNetwork' visualisation.
This function represent the difference between g1 and g2 (g1-g2).
}
\examples{
#on Angola dataset
library(igraph)
library(metanetwork)

data(meta_angola)

diff_plot(g1 = meta_angola$X2003,g2 = meta_angola$X1986,metanetwork = meta_angola,
beta = 0.05)



}
\seealso{
\code{\link[=attach_layout]{attach_layout()}}
}
