% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corsplom.R
\name{corsplom_data_frame}
\alias{corsplom_data_frame}
\title{Correlated Scatterplot Matrix Function for Data Frame}
\usage{
corsplom_data_frame(
  x,
  xvar = names(x),
  upper.panel = metOption("upper.panel_corsplom", if (gg) "corsplom_gg_scatter" else
    "corsplom_panel_scatter"),
  lower.panel = metOption("lower.panel_corsplom", if (gg) "corsplom_gg_correlation" else
    "corsplom_panel_correlation"),
  diag.panel = metOption("diag.panel_corsplom", if (gg) "corsplom_gg_diagonal" else
    "corsplom_panel_diagonal"),
  pscales = metOption("pscales_corsplom", 0),
  xlab = metOption("xlab_corsplom", NULL),
  varname.cex = metOption("varname.cex_corsplom", 1),
  main = metOption("main_corsplom", NULL),
  sub = metOption("sub_corsplom", NULL),
  col = metOption("col_corsplom", "blue"),
  smooth.col = metOption("smooth.col_corsplom", NULL),
  smooth.lty = metOption("smooth.lty_corsplom", "solid"),
  smooth.lwd = metOption("smooth.lwd_corsplom", 1),
  smooth.alpha = metOption("smooth.alpha_corsplom", 1),
  density = metOption("density_corsplom", TRUE),
  diag.label = metOption("diag.label_corsplom", "diag_label"),
  pin = metOption("pin_corsplom", "diag_pin"),
  pin.col = metOption("pin.col_corsplom", "darkgrey"),
  pin.alpha = metOption("pin.alpha_corsplom", 1),
  dens.col = metOption("dens.col_corsplom", "grey"),
  dens.scale = metOption("dens.scale_corsplom", 0.2),
  dens.alpha = metOption("dens.alpha_corsplom", 0.5),
  settings = metOption("settings.corsplom", NULL),
  padding = metOption("padding_corsplom", 1),
  as.table = metOption("as.table_corsplom", FALSE),
  dens.up = metOption("dens.up_corsplom", TRUE),
  gg = metOption("gg_corsplom", FALSE),
  verbose = metOption("verbose_corsplom", FALSE),
  ...
)
}
\arguments{
\item{x}{data.frame}

\item{xvar}{variables to plot}

\item{upper.panel}{passed to \code{\link[lattice]{splom}} or ggplot}

\item{lower.panel}{passed to \code{\link[lattice]{splom}} or ggplot}

\item{diag.panel}{passed to \code{\link[lattice]{splom}} or ggplot}

\item{pscales}{passed to \code{\link[lattice]{splom}}}

\item{xlab}{can be function(x = x, var = xvar, ...)}

\item{varname.cex}{text size multiplier}

\item{main}{character, or a function of x, xvar}

\item{sub}{character, or a function of x, xvar}

\item{col}{point color}

\item{smooth.col}{smooth color, defaults to col}

\item{smooth.lty}{smooth line type}

\item{smooth.lwd}{smooth line size}

\item{smooth.alpha}{smooth alpha}

\item{density}{whether to plot density polygons}

\item{diag.label}{label for the diagonal: a function of x, varname, .data}

\item{pin}{location for a pin (reference line) in the density region; can be function(x, varname, .data) or NULL to suppress}

\item{pin.col}{color of pin, if any}

\item{pin.alpha}{alpha transparency of pin}

\item{dens.col}{color for density region}

\item{dens.scale}{inflation factor for height of density smooth}

\item{dens.alpha}{alpha transparency for density region}

\item{settings}{default parameter settings: a list from which matching elements are passed to lattice (as par.settings) or  to ggplot theme()}

\item{padding}{numeric (will be recycled to length 4) giving plot margins in default units: top, right, bottom, left (in multiples of 5.5 points for ggplot)}

\item{as.table}{diagonal arranged top-left to bottom-right}

\item{dens.up}{whether density plots in diagonal should face the upper triangle vs. lower}

\item{gg}{logical: whether to generate \code{ggplot} instead of \code{trellis}}

\item{verbose}{generate messages describing process}

\item{...}{extra arguments passed to \code{\link[lattice]{splom}} and ggplot}
}
\value{
trellis or grob
}
\description{
Creates a scatterplot matrix with correlations in lower panel, by default.
}
\examples{

library(magrittr)
library(dplyr)
library(csv)
x <- as.csv(system.file(package = 'metaplot', 'extdata/theoph.csv'))
x \%<>\% pack
# setOption(gg = TRUE)
x \%>\% metaplot(lKe, lKa, lCl)
x \%>\% metaplot(
  lKe, lKa, lCl,
  col = 'black',smooth.col = 'red', pin.col = 'red',
  dens.col='blue',dens.alpha = 0.1
)
}
\seealso{
Other multivariate plots: 
\code{\link{corsplom.data.frame}()},
\code{\link{metaplot.data.frame}()}

Other corsplom: 
\code{\link{corsplom.data.frame}()},
\code{\link{corsplom_gg_correlation}()},
\code{\link{corsplom_gg_diagonal}()},
\code{\link{corsplom_gg_scatter}()},
\code{\link{corsplom_panel_correlation}()},
\code{\link{corsplom_panel_scatter}()},
\code{\link{corsplom}()},
\code{\link{plot.metaplot_gtable}()},
\code{\link{print.metaplot_gtable}()}

Other metaplot: 
\code{\link{boxplot_data_frame}()},
\code{\link{categorical_data_frame}()},
\code{\link{densplot_data_frame}()},
\code{\link{metaplot_key}()},
\code{\link{metaplot}()},
\code{\link{scatter_data_frame}()},
\code{\link{test_metaplot}()}
}
\concept{corsplom}
\concept{metaplot}
\concept{multivariate plots}
