% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpower.R
\name{mpower}
\alias{mpower}
\title{Compute Power for Meta-analysis}
\usage{
mpower(
  effect_size,
  study_size,
  k,
  i2,
  es_type,
  test_type = "two-tailed",
  p = 0.05,
  con_table = NULL
)
}
\arguments{
\item{effect_size}{Numerical value of effect size.}

\item{study_size}{Numerical value for number number of participants (per study).}

\item{k}{Numerical value for total number of studies.}

\item{i2}{Numerical value for Heterogeneity estimate (i^2).}

\item{es_type}{Character reflecting effect size metric: 'r', 'd', or 'or'.}

\item{test_type}{Character value reflecting test type: ("two-tailed" or "one-tailed").}

\item{p}{Numerical value for significance level (Type I error probability).}

\item{con_table}{(Optional) Numerical values for 2x2 contingency table as a vector in the following format: c(a,b,c,d).

\tabular{lcc}{
 2x2 Table   \tab Group 1 \tab Group 2 \cr
 Present     \tab a       \tab b       \cr
 Not Present \tab c       \tab d       \cr
}}
}
\value{
Estimated Power
}
\description{
Computes statistical power for summary effect sizes in meta-analysis.
}
\examples{
mpower(effect_size = .2, study_size = 10, k = 10, i2 = .5, es_type = "d")

}
\references{
Borenstein, M., Hedges, L. V., Higgins, J. P. T. and Rothstein, H. R.(2009). Introduction to meta-analysis, Chichester, UK: Wiley.

Hedges, L., Pigott, T. (2004). The Power of Statistical Tests for Moderators in Meta-Analysis, Psychological Methods, 9(4), 426-445
doi: https://dx.doi.org/10.1037/1082-989x.9.4.426

Pigott, T. (2012). Advances in Meta-Analysis.
doi: https://dx.doi.org/10.1007/978-1-4614-2278-5

Jackson, D., Turner, R. (2017). Power analysis for random-effects meta-analysis, Research Synthesis Methods, 8(3), 290-302
doi: https://dx.doi.org/10.1002/jrsm.1240
}
\seealso{
\url{https://jason-griffin.shinyapps.io/shiny_metapower/}
}
