% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_crumble_taxonomy.R
\name{crumble_taxonomy}
\alias{crumble_taxonomy}
\title{crumble_taxonomy}
\usage{
crumble_taxonomy(spectral_count_object, taxonomic_level, filter_rate = 1)
}
\arguments{
\item{spectral_count_object}{List defined as "spectral_count_object"
containing dataframes with abundance expressed as spectral counts
and organized by peptides, subgroups or groups. The format of 
this object is similar to that generated with the function 
"getsc_specific". Taxonomy must be added previously 
with "add_taxonomy" function.}

\item{taxonomic_level}{Character indicating the taxonomic level to which
the spectral abundance will be arranged in the samples of the 
"spectral_count_object". The possible options are: "species", "genus", 
"family", "order", "class", "phylum" or "superkingdom".}

\item{filter_rate}{Numeric value between 0 and 1 that indicates the 
minimal rate of consensual annotation desired by the user within each 
level of the spectral category (subgroup or group). This rate is defined 
as the ratio between the number of the most frequent annotation entity 
("species", "genus", "family", "order", "class", "phylum" or "superkingdom") 
divided by the total number of entities within each level of the spectral 
category under study (subgroup or group). The default value is set to 1, 
if 100 \% of consensus is desired.}
}
\value{
A list of four elements defined as "spectral_count_object", the first 
   element is a dataframe with abundance expressed as spectral counts of entities 
   (peptides, subgroups or groups) organized by the provided taxonomic level. 
   The second element is a dataframe that contains the experiment information. 
   The third element is a dataframe containing the information of peptides with 
   their associated proteins. And the fourth element is a character indicating 
   the type of object generated.
}
\description{
Generates a list of four elements defined as "spectral_count_object"
containing taxonomic classification. The first element is a dataset 
that contains the spectral counts abundance organized by a provided 
taxonomic level. The possible taxonomic levels are: species, genus, 
family, order, class, phylum or superkingdom.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)

superkingdom_fecalwaters <- crumble_taxonomy(fecal_waters, "superkingdom")

phylum_fecalwaters <- crumble_taxonomy(fecal_waters, "phylum")

class_fecalwaters <- crumble_taxonomy(fecal_waters, "class")

order_fecalwaters <- crumble_taxonomy(fecal_waters, "order")

family_fecalwaters <- crumble_taxonomy(fecal_waters, "family")

genus_fecalwaters <- crumble_taxonomy(fecal_waters, "genus")

species_fecalwaters <- crumble_taxonomy(fecal_waters, "species")

\dontshow{setwd(.old_wd)}
}
