% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_export_robject.R
\name{export_robject}
\alias{export_robject}
\title{export_robject}
\usage{
export_robject(entry_object, data_exported, format_data, force = FALSE)
}
\arguments{
\item{entry_object}{A "metaproteome_object" or a "spectral_count_object" with
similar format to that generated with the functions "load_protspeps" or 
"getsc_specific", respectively.}

\item{data_exported}{Character indicating the type of data to be exported from 
a "metaproteome_object" or a "spectral_count_object". The possible options 
are: i) "proteins", ii) "peptides", iii) "pepProts", iv) "spectral", 
v) "spectral_percent", vi) "metadata".}

\item{format_data}{Character indicating the file extension, this can be 
either "RDATA" or "RDS".}

\item{force}{Logic value set at FALSE by default in order to ask permission 
to create object in the workstation of the user.}
}
\value{
A file with the extension "RDATA" or "RDS" containing the information 
   from the selected dataframe from a "metaproteome_object" or a 
   "spectral_count_object".
}
\description{
Exports one of the dataframes present in a "metaproteome_object"
or in "spectral_count_object". The export extensions can be RDATA or RDS.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
export_robject(fecal_waters, "pepProts", "rdata")

data(species_fw)
export_robject(species_fw, "spectral", "rds")

\dontshow{setwd(.old_wd)}
}
