% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan_plot.R
\name{esm_manhattan_plot}
\alias{esm_manhattan_plot}
\title{Manhattan plot of feature-cluster association p-values}
\usage{
esm_manhattan_plot(
  esm,
  neg_log_pval_thresh = 5,
  threshold = NULL,
  point_size = 5,
  jitter_width = 0.1,
  jitter_height = 0.1,
  text_size = 15,
  plot_title = NULL,
  hide_x_labels = FALSE,
  bonferroni_line = FALSE
)
}
\arguments{
\item{esm}{Extended solutions data frame storing associations between features
and cluster assignments. See \code{?extend_solutions}.}

\item{neg_log_pval_thresh}{Threshold for negative log p-values.}

\item{threshold}{P-value threshold to plot dashed line at.}

\item{point_size}{Size of points in the plot.}

\item{jitter_width}{Width of jitter.}

\item{jitter_height}{Height of jitter.}

\item{text_size}{Size of text in the plot.}

\item{plot_title}{Title of the plot.}

\item{hide_x_labels}{If TRUE, hides x-axis labels.}

\item{bonferroni_line}{If TRUE, plots a dashed black line at the
Bonferroni-corrected equivalent of the p-value threshold.}
}
\value{
A Manhattan plot (class "gg", "ggplot") showing the association
p-values of features against each solution in the provided solutions data frame.
}
\description{
Manhattan plot of feature-cluster association p-values
}
\examples{
esm_manhattan_plot(mock_ext_solutions_df)
}
