% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_snf.R
\name{snf_step}
\alias{snf_step}
\title{Helper function for using the correct SNF scheme}
\usage{
snf_step(
  dl,
  scheme,
  k = 20,
  alpha = 0.5,
  t = 20,
  cnt_dist_fn,
  dsc_dist_fn,
  ord_dist_fn,
  cat_dist_fn,
  mix_dist_fn,
  weights_row
)
}
\arguments{
\item{dl}{A nested list of input data from \code{data_list()}.}

\item{scheme}{Which SNF system to use to achieve the final fused network.}

\item{k}{k hyperparameter.}

\item{alpha}{alpha/eta/sigma hyperparameter.}

\item{t}{SNF number of iterations hyperparameter.}

\item{cnt_dist_fn}{distance metric function for continuous data.}

\item{dsc_dist_fn}{distance metric function for discrete data.}

\item{ord_dist_fn}{distance metric function for ordinal data.}

\item{cat_dist_fn}{distance metric function for categorical data.}

\item{mix_dist_fn}{distance metric function for mixed data.}

\item{weights_row}{data frame row containing feature weights.}
}
\value{
A fused similarity network (matrix).
}
\description{
Helper function for using the correct SNF scheme
}
\keyword{internal}
