% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_operators.R
\name{df_dp}
\alias{df_dp}
\title{df_dp}
\usage{
df_dp(fld, plev = 5000)
}
\arguments{
\item{fld}{field with dimensions (lon,lat,p)}

\item{plev}{a scalar containing the p resolution (if equidistant) or a vector containing pressure levels in Pa (for non-equidistant)}
}
\value{
field containing the partial derivative w.r.t. p
}
\description{
Calculates the p derivative (pressure system) using central differences
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
theta=calc_theta(data$temp,data$lev)
dtheta_dp=df_dp(theta)
}
