% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_operators.R
\name{df_dy}
\alias{df_dy}
\title{df_dy}
\usage{
df_dy(fld, dy = 0.25, mode = "lonlat")
}
\arguments{
\item{fld}{with dimensions (lon,lat,p)}

\item{dy}{y resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{mode}{the coordinate system, options are lonlat for a longitude-latitude-grid (default), or cartesian for an equidistant cartesian grid}
}
\value{
field containing the partial derivative w.r.t. y
}
\description{
Calculates the y derivative using central differences
}
\examples{
myfile=system.file("extdata", "era5_storm-zeynep.nc", package = "meteoEVT")
data = readin_era5(myfile)
theta=calc_theta(data$temp,data$lev)
dtheta_dy=df_dy(theta,dy=0.25)
}
