% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{as.mcmc.metropolis.samples}
\alias{as.mcmc.metropolis.samples}
\title{Convert glm_metropolis output to \code{mcmc} object from package coda}
\usage{
\method{as.mcmc}{metropolis.samples}(x, ...)
}
\arguments{
\item{x}{an object from the function "metropolis"}

\item{...}{not used}
}
\value{
An object of type "mcmc" from the coda package
}
\description{
Allows use of useful functions from \code{coda} package
}
\details{
TBA
}
\examples{
\dontrun{
library("coda")
dat = data.frame(y = rbinom(100, 1, 0.5), x1=runif(100), x2 = runif(100))
res = metropolis_glm(y ~ x1 + x2, data=dat, family=binomial(), iter=10000, burnin=3000, 
adapt=TRUE, guided=TRUE, block=FALSE)
res2 = as.mcmc(res)
summary(res2)
}
}
