% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevr.R
\name{fmev}
\alias{fmev}
\title{Fitting the Metastatistical Extreme Value Distribution (MEVD)}
\usage{
fmev(data, threshold = 0, method = c("pwm", "mle", "ls"))
}
\arguments{
\item{data}{The data to which the MEVD should be fitted to. \code{data} must be a data.frame with two columns. 
The first column must contain dates of class  \code{Date}, the second or last column must contain the rainfall 
values corresponding to datums in the rows. No negative values are allowed. NA values are removed with a warning.}

\item{threshold}{A numeric that is used to define wet days as values > threshold. 
\eqn{data <= threshold} is set to NA.}

\item{method}{Character string describing the method that is used to estimate the 
Weibull parameters c and w. Possible options are probability weighted moments (\code{method='pwm'}), 
maximum likelihood (\code{method='mle'}) or least squares (\code{method='ls'}). 
The \code{default} is \code{pwm}. (see details).}
}
\value{
A list of class \code{mevr} with the fitted Weibull parameters and other helpful ingredients.
\item{c}{ vector of Weibull scale parameters of the MEVD, each component refers to one year.}
\item{w}{ vector of Weibull shape parameters of the MEVD, each component refers to one year.}
\item{n}{ Number of wet events per year. Wet events are defined as rainfall > \code{threshold}.}
\item{params}{ A named vector of the fitted parameters. }
\item{maxima}{ Maximum values corresponding to each year.}
\item{data}{ \eqn{data >= threshold} used to fit the MEVD and additional components which may be useful for further analysis.}
\item{years}{ Vector of years as YYYY.}
\item{threshold}{ The chosen threshold.}
\item{method}{ Method used to fit the MEVD.}
\item{type}{ The type of distribution ("MEVD")}
}
\description{
Fit the MEVD distribution to rainfall observations with different estimation methods.
}
\details{
With the aim of weakening the requirement of an asymptotic assumption for the GEV distribution, 
a metastatistical approach was proposed by Marani and Ignaccolo (2015). The MEVD is defined 
in terms of the distribution of the statistical parameters describing "ordinary" daily rainfall 
occurrence and intensity. The MEVD accounts for the random process of event occurrence in each 
block and the possibly changing probability distribution of event magnitudes across different blocks, 
by recognizing the number of events in each block, n, and the values of the shape and scale 
parameters w and C of the parent Weibull distribution to be realisations of stochastic variables. 
The MEVD can then be written as

\deqn{F = \frac{1}{T} \sum_{j=1}^T \prod_{k \in A_j} \left( 1-e^{-\left(\frac{x}{C(j,k)}\right)^{w(j,k)}} \right)}

for \eqn{w > 0} and \eqn{C > 0}. With T fully recorded years, yearly C and w can be estimated 
by fitting a Weibull distribution to the values x of this year, and n is the number of ordinary 
events per year, i.e. all rainfall events larger than a threshold. 

If the probability distribution of daily rainfall is assumed to be time-invariant, the MEVD can be simplified to 

\deqn{F = [1 - exp(-x/C)^w]^n}

with single values for the shape and scale parameters w and C. n is then the mean number of wet 
days at this location (Marra et al., 2019; Schellander et al., 2019).

As is shown e.g. Schellander et al., 2019, probability weighted moments should be preferred 
over maximum likelihood for the estimation of the Weibull parameters w and C. 
Therefore \code{method = 'pwm'} is the default.

The MEVD can also be used for sub-daily precipitation (Marra et al., 2019). 
In that case n has to be adapted accordingly to the 'mean number of wet events' per year.

This function returns the parameters of the fitted MEVD distribution as well as some 
additional fitting results and input parameters useful for further analysis.
}
\examples{
data(dailyrainfall)
fit <- fmev(dailyrainfall, method = "mle")
fit
plot(fit)

}
\references{
Marani, M. and Ignaccolo, M. (2015) 'A metastatistical approach to rainfall extremes', Advances in Water Resources. Elsevier Ltd, 79(Supplement C), pp. 121-126. doi: 10.1016/j.advwatres.2015.03.001.

Schellander, H., Lieb, A. and Hell, T. (2019) 'Error Structure of Metastatistical and Generalized Extreme Value Distributions for Modeling Extreme Rainfall in Austria', Earth and Space Science, 6, pp. 1616-1632. doi: 10.1029/2019ea000557.
}
\seealso{
\code{\link{fsmev}}, \code{\link{ftmev}}
}
\author{
Harald Schellander, Alexander Lieb
}
