% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{discr.sims.fat_tails}
\alias{discr.sims.fat_tails}
\title{Discriminability Spread Simulation}
\usage{
discr.sims.fat_tails(
  n,
  d,
  K,
  signal.scale = 1,
  rotate = FALSE,
  class.equal = TRUE,
  ind = FALSE
)
}
\arguments{
\item{n}{the number of samples.}

\item{d}{the number of dimensions.}

\item{K}{the number of classes in the dataset.}

\item{signal.scale}{the scaling for the signal dimension. Defaults to \code{1}.}

\item{rotate}{whether to apply a random rotation. Defaults to \code{TRUE}.}

\item{class.equal}{whether the number of samples/class should be equal, with each
class having a prior of 1/K, or inequal, in which each class obtains a prior
of k/sum(K) for k=1:K. Defaults to \code{TRUE}.}

\item{ind}{whether to sample x and y independently. Defaults to \code{FALSE}.}
}
\description{
A function to simulate data with the same mean that spreads as class id increases.
}
\examples{
library(mgc)
sim <- discr.sims.fat_tails(100, 3, 2)
}
\author{
Eric Bridgeford
}
