% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGCLocalCorr.R
\name{mgc.localcorr.driver}
\alias{mgc.localcorr.driver}
\title{Driver for MGC Local Correlations}
\usage{
mgc.localcorr.driver(DX, DY, option = "mgc")
}
\arguments{
\item{DX}{the first distance matrix.}

\item{DY}{the second distance matrix.}

\item{option}{is a string that specifies which global correlation to build up-on. Defaults to \code{'mgc'}.
\describe{
   \item{\code{'mgc'}}{use the MGC global correlation.}
   \item{\code{'dcor'}}{use the dcor global correlation.}
   \item{\code{'mantel'}}{use the mantel global correlation.}
   \item{\code{'rank'}}{use the rank global correlation.}
}}
}
\value{
A list contains the following:
\item{\code{corr}}{consists of all local correlations within [-1,1] by double matrix index}
\item{\code{varX}}{contains all local variances for X.}
\item{\code{varY}}{contains all local variances for X.}
}
\description{
Driver for MGC Local Correlations
}
\author{
C. Shen
}
