% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mglasso.R
\name{mglasso}
\alias{mglasso}
\title{Inference of Multiscale Gaussian Graphical Model.}
\usage{
mglasso(
  x,
  lambda1 = 0,
  fuse_thresh = 0.001,
  maxit = NULL,
  distance = c("euclidean", "relative"),
  lambda2_start = 1e-04,
  lambda2_factor = 1.5,
  precision = 0.01,
  weights_ = NULL,
  type = c("initial"),
  compact = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{x}{Numeric matrix (\eqn{n x p}). Multivariate normal sample with
\eqn{n} independent observations.}

\item{lambda1}{Positive numeric scalar. Lasso penalty.}

\item{fuse_thresh}{Positive numeric scalar. Threshold for clusters fusion.}

\item{maxit}{Integer scalar. Maximum number of iterations.}

\item{distance}{Character. Distance between regression vectors with
permutation on symmetric coefficients.}

\item{lambda2_start}{Numeric scalar. Starting value for fused-group Lasso
penalty (clustering penalty).}

\item{lambda2_factor}{Numeric scalar. Step used to update fused-group Lasso
penalty in a multiplicative way..}

\item{precision}{Tolerance for the stopping criterion (duality gap).}

\item{weights_}{Matrix of weights.}

\item{type}{If "initial" use classical version of \strong{MGLasso} without
weights.}

\item{compact}{Logical scalar. If TRUE, only save results when previous
clusters are different from current.}

\item{verbose}{Logical scalar. Print trace. Default value is FALSE.}
}
\value{
A list-like object of class \code{mglasso} is returned.
\item{out}{List of lists. Each element of the list corresponds to a
clustering level. An element named \code{levelk} contains the regression
matrix \code{beta} and clusters vector \code{clusters} for a clustering in
\code{k} clusters. When \code{compact = TRUE} \code{out} has as many
elements as the number of unique partitions. When set to \code{FALSE}, the
function returns as many items as the the range of values taken by
\code{lambda2}.} \item{l1}{the sparsity penalty \code{lambda1} used in the
problem solving.}
}
\description{
Cluster variables using L2 fusion penalty and simultaneously estimates a
gaussian graphical model structure with the addition of L1 sparsity penalty.
}
\details{
Estimates a gaussian graphical model structure while hierarchically grouping
variables by optimizing a pseudo-likelihood function combining Lasso and
fuse-group Lasso penalties. The problem is solved via the \emph{COntinuation
with NEsterov smoothing in a Shrinkage-Thresholding Algorithm} (Hadj-Selem et
al. 2018). Varying the fusion penalty \eqn{\lambda_2} in a multiplicative
fashion allow to uncover a seemingly hierarchical clustering structure. For
\eqn{\lambda_2 = 0}, the approach is theoretically equivalent to the
Meinshausen-Bühlmann (2006) \emph{neighborhood selection} as resuming to the
optimization of \emph{pseudo-likelihood} function with \eqn{\ell_1} penalty
(Rocha et al., 2008). The algorithm stops when all the variables have merged
into one cluster. The criterion used to merge clusters is the
\eqn{\ell_2}-norm distance between regression vectors.

For each iteration of the algorithm, the following function is optimized :
\deqn{1/2 \sum_{i=1}^p || X^i - X^{\ i} \beta^i ||_2 ^2  + \lambda_1 \sum_{i
= 1}^p || \beta^i ||_1 + \lambda_2 \sum_{i < j} || \beta^i -
\tau_{ij}(\beta^j) ||_2.}

where \eqn{\beta^i} is the vector of coefficients obtained after regression
\eqn{X^i} on the others and \eqn{\tau_{ij}} is a permutation exchanging
\eqn{\beta_j^i} with \eqn{\beta_i^j}.
}
\examples{
\dontrun{
reticulate::use_condaenv("rmglasso", required = TRUE)
n = 50
K = 3
p = 9
rho = 0.85
blocs <- list()
for (j in 1:K) {
  bloc <- matrix(rho, nrow = p/K, ncol = p/K)
  for(i in 1:(p/K)) { bloc[i,i] <- 1 }
  blocs[[j]] <- bloc
}

mat.covariance <- Matrix::bdiag(blocs)
mat.covariance

set.seed(11)
X <- mvtnorm::rmvnorm(n, mean = rep(0,p), sigma = as.matrix(mat.covariance))
X <- scale(X)

res <- mglasso(X, 0.1, lambda2_start = 0.1)
res$out[[1]]$clusters
res$out[[1]]$beta
}
}
\seealso{
\code{\link[=conesta]{conesta()}} for the problem solver,
\code{\link[=plot_mglasso]{plot_mglasso()}} for plotting the output of \code{mglasso}.
}
