% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocs.R
\docType{data}
\name{anemia}
\alias{anemia}
\title{Aplastic anemia clinical trial data.}
\format{
A data frame with 64 rows and 5 variables:
\describe{
\item{Treatment:}{Treatment group, either cyclosporine and methotrexate
(CSPMTX) or methotrexate only (MTX).}
\item{Time:}{Time in days to severe (stage >=2) acute graft versus host
disease, death, or last contact.}
\item{LAF:}{Patient assigned to laminar air flow isolation room at
baseline. LAF = 1 signifies yes, LAF = 0 signifies no.}
\item{Age:}{Age of patient in years.}
\item{Censored:}{Boolean for whether or not time to severe A-GVHD is
right-censored; i.e., the patient died without severe A-GVHD or was
without severe A-GVHD at last contact.}
}
}
\source{
Table 1.1, page 14 of Prentice and Zhao 2019, taken from
Table 1.2 on page 3 in The Statistical Analysis of Failure Time Data,
Second Edition, by J. D. Kalbfleisch and R. L. Prentice. New York: Wiley
and Sons, 2002.
}
\usage{
data(anemia)
}
\description{
Failure time data for 64 patients having severe aplastic anemia. Patients
were randomly assigned to receive either cyclosporine plus methotrexate
(CSPMTX) or methotrexate alone (MTX) with time from assignment to the
diagnosis of stage 2 or greater acute graft versus host disease (A-GVHD)
as a key outcome.
}
\references{
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
}
\keyword{datasets}
