% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changefunctions.R
\name{plotchange}
\alias{plotchange}
\title{plotchange}
\usage{
plotchange(zvec, rbuff = 25, h = 30, ...)
}
\arguments{
\item{zvec}{vector of transformed order statistic of p values}

\item{rbuff}{right buffer}

\item{h}{window size}

\item{...}{any graphical parameters passed to the plot function}
}
\value{
Nothing
}
\description{
Plot the change function that is maximized to find the change point.
}
\details{
Currently there are two types of change functions supported. The difference between first difference series and the difference in gradients at each point. Both of these functions should have a theoretical maximum at the change point. We plot these two series side by side along with indicating the change point.
}
\examples{
  
\dontrun{      
n = 50;m = 250;m0 = 20;
sigeff = 1;
Sigma <- 0.25*diag(m)
X <- datgen(n,m,m0,sigeff,Sigma = Sigma)
porder <- pboot.1sample(X=X,B=100,ncpus = 1)
plotchange(porder[1,])
}
}

