% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVNPlotObject.R
\name{getVNPlotObject}
\alias{getVNPlotObject}
\title{getVNPlotObject}
\usage{
getVNPlotObject(
  nodes,
  edges,
  addLegend = FALSE,
  addExport = TRUE,
  figType = "png",
  mainTitle = NULL,
  subTitle = NULL,
  layoutSeed = NA,
  scaleNodes = FALSE,
  scaleEdges = FALSE,
  microbeCol = "gold",
  resourceCol = "lightblue",
  productionCol = "magenta",
  uptakeCol = "darkgrey",
  figWidth = 700,
  figHeight = 700
)
}
\arguments{
\item{nodes}{data frame or a list with nodes information. Needs at least column "id". See visNetwork::visNodes}

\item{edges}{data frame or a list with edges information. Needs at least columns "from" and "to". See visNetwork::visEdges}

\item{addLegend}{Logical. If true adds a legend to plot. Default is FALSE}

\item{addExport}{Logical. If true adds button to export fig from html plot}

\item{figType}{Type of export. One of "png" (default), "jpeg" or "pdf". Puts a button on the html plot}

\item{mainTitle}{Optional list containing "text" (string for plot title) and "style" (e.g. 'font-family:Times','font-family:Arial' etc).}

\item{subTitle}{Optional list containing "text" (string for plot subtitle) and "style" (e.g. 'font-family:Times','font-family:Arial' etc)}

\item{layoutSeed}{: NA. Random seed for the layout of the plot. To get identical plots set this to a number}

\item{scaleNodes}{Logical. If true the node sizes differ with concentration (in moles for resources and mass or concentration for microbes)}

\item{scaleEdges}{Logical. If true the edge sizes differ with the amount of moles flowing through them}

\item{microbeCol}{String for microbe node colour. Default is 'orange'}

\item{resourceCol}{String for resource node colour. Default is 'lightBlue'}

\item{productionCol}{String for production edge colour. Default is 'darkGrey'}

\item{uptakeCol}{String for uptake edge colour. Default is 'magenta'}

\item{figWidth}{numeric value to control size of plotting window. Default is 700}

\item{figHeight}{numeric value to control size of plotting window. Default is 700}
}
\value{
a visNetwork object that can be shown using print() function.
}
\description{
uses visNetwork to produce an interactive network plot based on the links and edges dataframes
}
