% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{study_results}
\alias{study_results}
\title{Case-study results}
\format{
\code{data.table} with 50 rows and 6 columns:
\describe{
\item{\code{program}}{Character, academic program label.}
\item{\code{sex}}{Character, sex as self-reported by the student,
possible values are Female, Male, and Unknown.}
\item{\code{race}}{Character, race/ethnicity as self-reported
by the student, e.g., Asian, Black, Latine, etc.}
\item{\code{ever_enrolled}}{Numerical, number of students
ever enrolled in a program.}
\item{\code{graduates}}{Numerical, number of students completing
a program.}
\item{\code{stickiness}}{Numerical, program stickiness, the
ratio of \code{graduates} to \code{ever_enrolled}, in percent.}
}
}
\usage{
study_results
}
\description{
Data table of longitudinal stickiness for the four programs of the case study
(Civil, Electrical, Industrial/Systems, and Mechanical Engineering) grouped
by program, race/ethnicity, and sex. Provided for the convenience of vignette
users.
}
\details{
Longitudinal stickiness is the ratio of the number of students graduating
from a program to the number of students ever enrolled in the program over
the time span of available data. Results are based on data that have been
filtered for data sufficiency, degree seeking, and timely completion.
}
\seealso{
Other case-study-data: 
\code{\link{baseline_mcid}},
\code{\link{study_observations}},
\code{\link{study_programs}}
}
\concept{case-study-data}
\keyword{datasets}
