% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_bilat.R
\name{sum_bilat}
\alias{sum_bilat}
\title{Summary of bilateral flows, counter-flow and net migration flow}
\usage{
sum_bilat(m, label = "flow", orig = "orig", dest = "dest", flow = "flow")
}
\arguments{
\item{m}{A \code{matrix} or data frame of origin-destination flows. For \code{matrix} the first and second dimensions correspond to origin and destination respectively. For a data frame ensure the correct column names are passed to \code{orig}, \code{dest} and \code{flow}.}

\item{label}{Character string for the prefix of the calculated columns. Can take values \code{flow} or \code{stream}}

\item{orig}{Character string of the origin column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{dest}{Character string of the destination column name (when \code{m} is a data frame rather than a \code{matrix})}

\item{flow}{Character string of the flow column name (when \code{m} is a data frame rather than a \code{matrix})}
}
\value{
A \code{tibble} with columns for orig, destination, corridor, flow, counter-flow and net flow in each bilateral pair.
}
\description{
Summary of bilateral flows, counter-flow and net migration flow
}
\examples{
# using matrix
r <- LETTERS[1:4]
m <- matrix(data = c(0, 100, 30, 70, 50, 0, 45, 5, 60, 35, 0, 40, 20, 25, 20, 0),
            nrow = 4, ncol = 4, dimnames = list(orig = r, dest = r), byrow = TRUE)
m
sum_bilat(m)

# using data frame
library(dplyr)
library(tidyr)
d <- expand_grid(orig = r, dest = r, sex = c("female", "male")) \%>\%
  mutate(flow = sample(x = 1:100, size = 32))
d

# orig-dest summary of sex-specific flows
d \%>\%
  group_by(sex) \%>\%
  sum_bilat()

# use group_by to distinguish orig-dest tables
d \%>\%
  group_by(sex) \%>\%
  sum_bilat()
}
