% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{rSMB_partition}
\alias{rSMB_partition}
\title{Simulation of mixture multilayer Stochastick block model}
\usage{
rSMB_partition(N, V, K, pi_k, rho, sorted = TRUE, p_switch = NULL)
}
\arguments{
\item{N}{Number of observations}

\item{V}{Number of views}

\item{K}{Vector of size Q, indicate the number of clusters in each component.}

\item{pi_k}{Vector of proportions of observations across clusters.}

\item{rho}{Vector of proportion of views across components.}

\item{sorted}{Boolean for simulation reordering (clusters and components membership).}

\item{p_switch}{probability of label-switching, if NULL no perturbation between true clustering and the connectivity of individuals.}
}
\value{
list with the parameters of the simulation ($params), and the simulations ($simulation).
}
\description{
This simulation process assumes that we have partial information on the clustering within each view component, and that the final clustering of individuals depends on a combination of the clustering on each of the views.
In addition, we take into account possible label-switching: we consider that an individual belongs with a certain probability to the wrong class, thus disturbing the adjacency matrices and making the simulation more real and complex.
}
\details{
See the vignette for more information.
}
